<?php $__env->startSection('title'); ?>
Token Management
<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>
<div class="row wrapper border-bottom white-bg page-heading">
	<div class="col-lg-12">
		<h2><i class="fa fa-arrows" aria-hidden="true"></i> Token Management</h2>
		<ol class="breadcrumb">
			<li class="breadcrumb-item">
				<a href="<?php echo e(route('admin.dashboard')); ?>">Home</a>
			</li>
			<li class="breadcrumb-item active">
				<span class="label label-success float-right all_backgroud"><strong>Token Table</strong></span>
			</li>
		</ol>
	</div>
</div>

<div class="wrapper wrapper-content">
	<div class="row">
		<div class="col-lg-12">
			<div class="ibox">
				<div class="ibox-content">
					<div class="col-md-12">
						<div class="table-responsive">
							<?php echo $html->table(['class' => 'table table-striped table-bordered dt-responsive'], true); ?>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="https://cdn.datatables.net/v/dt/dt-1.10.16/datatables.min.js"></script>
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.min.js"></script>
<?php echo $html->scripts(); ?>

<script type="text/javascript">
	$(document).on("click","a.deletetoken",function(e){
		var row = $(this);
		var id = $(this).attr('data-id');
		swal({
			title: "Are you sure?",
			text: "You will not be able to recover this record",
			type: "warning",
			showCancelButton: true,
			confirmButtonColor: "#e69a2a",
			confirmButtonText: "Yes, delete it!",
			cancelButtonText: "No, cancel please!",
			closeOnConfirm: false,
			closeOnCancel: false
		}, function(isConfirm){
			if (isConfirm) {
				$.ajax({
					url:"<?php echo e(route('admin.token.delete',[''])); ?>"+"/"+id,
					type: 'post',
					data: {"_token": "<?php echo e(csrf_token()); ?>"
				},
				success:function(msg){
					if(msg.status == 'success'){
						swal({title: "Deleted",text: "Delete Record success",type: "success"},
							function(){ 
								location.reload();
							});
					}else{
						swal("Warning!", msg.message, "warning");
					}
				},
				error:function(){
					swal("Error!", 'Error in delete Record', "error");
				}
			});
			} else {
				swal("Cancelled", "Your Token is safe :)", "error");
			}
		});
		return false;
	})
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /customers/d/5/1/projects-beta.com/httpd.www/chamoise/resources/views/admin/pages/token/index.blade.php ENDPATH**/ ?>